
//////////////////////////
//Created by LostSinner//
////////////////////////
using System;
using Server.Network;
using Server.Items;
using System.Collections.Generic;
using System.Collections;
using Server.Mobiles;

namespace Server.Items
{
 
	[FlipableAttribute( 0x26C2, 0x26CC )]
 	public class VampiriacBow : NoAmmoRanged
 	{
  		public override int EffectID{ get{ return 0xF42; } }
  		public override int EffectHue{ get{ return (this.Hue - 1); } }
      
  		public override WeaponAbility PrimaryAbility{ get{ return WeaponAbility.ArmorIgnore; } }
  		public override WeaponAbility SecondaryAbility{ get{ return WeaponAbility.MovingShot; } }
 
  		public override int AosStrengthReq{ get{ return 30; } }
  		public override int AosMinDamage{ get{ return 16; } }
  		public override int AosMaxDamage{ get{ return 18; } }
  		public override int AosSpeed{ get{ return 25; } }
 
  		public override int OldStrengthReq{ get{ return 20; } }
  		public override int OldMinDamage{ get{ return 9; } }
  		public override int OldMaxDamage{ get{ return 20; } }
  		public override int OldSpeed{ get{ return 20; } }
 
 		public override int DefMaxRange{ get{ return 10; } }
 
  		public override int InitMinHits{ get{ return 125; } }
  		public override int InitMaxHits{ get{ return 125; } }
 
  		public override WeaponAnimation DefAnimation{ get{ return WeaponAnimation.ShootBow; } }
 
  		[Constructable]
  		public VampiriacBow() : base( 0x26C2 )
  		{
   		Weight = 6.0;
   		Name = "A Vampiriac Bow";
   		Hue = 37;
   		Layer = Layer.TwoHanded;
   		LootType = LootType.Cursed;
			Attributes.SpellChanneling = 1;
   		Attributes.WeaponSpeed = 30;
   		Attributes.WeaponDamage = 15;
   		Attributes.AttackChance = 20;
   		WeaponAttributes.HitLeechHits = 25;
   		Attributes.CastSpeed = 2;
   		Attributes.CastRecovery = 2;
 		 }
 		 
		public override bool OnFired( Mobile attacker, Mobile defender )
		{
			attacker.MovingEffect( defender, EffectID, 18, 1, false, false, EffectHue, 0 );
			
			if ( !attacker.Player )
			   return true;
			   
			ArrayList targets = Utilitky.GetPlayerTargets( defender, 3 );
			int lifeLeech = 0;
			
			for (int i = 0; i <  Math.Min( targets.Count, 11 ); ++i)
			{
				Mobile m = (Mobile)targets[i];
				
				if ( m == null || m.Deleted || !m.Alive )
					continue;
					
				if ( CheckHit( attacker, m ) )
            {
               PlayHurtAnimation( m );
               m.PlaySound(GetHitDefendSound(attacker, m));
               int damage = AOS.Scale( ComputeDamage(attacker, m), 90 );
               
               if (m is BaseCreature)
                  ((BaseCreature)m).AlterMeleeDamageFrom(attacker, ref damage);
              
               AddBlood(attacker, m, damage);
               m.Damage( AOS.Damage(m, attacker, damage, false, 20, 20, 20, 20, 20, false, false, 1), attacker );
               
               if ( WeaponAttributes.HitLeechHits > Utility.Random(100) )
                  lifeLeech += AOS.Scale(damage, 10);                           
            }
				else
					OnMiss( attacker, m );
				
				attacker.MovingEffect( m, EffectID, 18, 1, false, false, EffectHue, 0 );
			}
			
         if ( lifeLeech != 0 )
            attacker.Hits += Math.Min( lifeLeech, AOS.Scale( attacker.HitsMax, 20 ) );
			
			return true;
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#9999FF>Multishot<basefont color=White>" );
		}
 
 		 public VampiriacBow( Serial serial ) : base( serial )
  		 {
  		 }
 	
  		 public override void Serialize( GenericWriter writer )
 		 {
  		 	base.Serialize( writer );
 
 	  	 	writer.Write( (int) 0 ); // version
 		 }
 
  		 public override void Deserialize( GenericReader reader )
 		 {
  			 base.Deserialize( reader );
 
  			 int version = reader.ReadInt();
 
   			if ( Weight == 7.0 )
   			 Weight = 6.0;
  		 }
	}
}
